package gov.va.vamf.scheduling.varutility.service;


import gov.va.vamf.scheduling.varutility.datalayer.RequestEligibilityCriteriaRepository;
import gov.va.vamf.scheduling.varutility.domain.*;
import gov.va.vamf.scheduling.varutility.utils.SpringBasedIntegrationRepo;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

import javax.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static org.junit.Assert.assertEquals;

public class RequestEligibilityCriteriaServiceTest  extends SpringBasedIntegrationRepo {

    @Autowired
    RequestEligibilityCriteriaService requestEligibilityCriteriaService;

    @Autowired
    RequestEligibilityCriteriaRepository requestEligibilityCriteriaRepository;

    UriInfo uriInfo;

    @Before
    public void setup() {
        RequestEligibilityCriteria requestEligibilityCriteria = new RequestEligibilityCriteria();
        CoreSettings cs = new CoreSettings();
        CoreSetting c = new CoreSetting();
        c.setId("323");
        c.setTypeOfCare("Test Primary Care");
        c.setPatientHistoryRequired("yes");
        c.setPatientHistoryDuration(720);
        c.setSubmittedRequestLimit(1);
        cs.add(c);
        requestEligibilityCriteria.setId("1");
        requestEligibilityCriteria.setRequestSettings(cs);
        requestEligibilityCriteriaService.saveRequestEligibilityCriteria(requestEligibilityCriteria);
        uriInfo = Mockito.mock(UriInfo.class);
        Mockito.when(uriInfo.getRequestUri())
                .thenReturn(URI.create("http://localhost:8080/test"));
    }

    @After
    public void tearDown() {
        requestEligibilityCriteriaRepository.deleteAll();
    }

    //@Test
    public void testCreateRequestEligibilityCriteria() {
        RequestEligibilityCriteria requestEligibilityCriteria = requestEligibilityCriteriaService.fetchRequestEligibiltyCriteria("123", createClinicalServices(), createClinicalServicesForCustomRequest(), uriInfo);
        TestCase.assertNotNull(requestEligibilityCriteria);
        assertEquals(2, requestEligibilityCriteria.getRequestSettings().size());
    }

    @Test
    public void testUpdateCriteriaCoreSettingsWillAddCoreSetting() {
        RequestEligibilityCriteria requestEligibilityCriteria = requestEligibilityCriteriaRepository.findById("1");
        TestCase.assertNotNull(requestEligibilityCriteria);
        assertEquals(1, requestEligibilityCriteria.getRequestSettings().size());
        requestEligibilityCriteria = requestEligibilityCriteriaService.fetchRequestEligibiltyCriteria("1", createClinicalServices(), createClinicalServicesForCustomRequest(), uriInfo);
        TestCase.assertNotNull(requestEligibilityCriteria);
        assertEquals(2, requestEligibilityCriteria.getRequestSettings().size());
    }

    @Test
    public void testUpdateCriteriaCoreSettingsWillAddRemoveCoreSetting() {
        RequestEligibilityCriteria requestEligibilityCriteria = requestEligibilityCriteriaRepository.findById("1");
        TestCase.assertNotNull(requestEligibilityCriteria);
        CoreSettings coreSettings = requestEligibilityCriteria.getRequestSettings();
        assertEquals(1, coreSettings.size());
        CoreSetting coreSetting = coreSettings.get(0);
        assertEquals("Test Primary Care", coreSetting.getTypeOfCare());
        List<ClinicalServices> clinicalServicesList = createUpdatedClinicalServices();
        requestEligibilityCriteria = requestEligibilityCriteriaService.fetchRequestEligibiltyCriteria("1", clinicalServicesList, createClinicalServicesForCustomRequest(), uriInfo);
        TestCase.assertNotNull(requestEligibilityCriteria);
        coreSettings = requestEligibilityCriteria.getRequestSettings();
        assertEquals(1, coreSettings.size());
        coreSetting = coreSettings.get(0);
        assertEquals("Test Radiology", coreSetting.getTypeOfCare());
    }

    @Test
    public void testUpdateCriteriaCoreSettingsWillChangeCoreSettingName() {
        RequestEligibilityCriteria requestEligibilityCriteria = requestEligibilityCriteriaRepository.findById("1");
        TestCase.assertNotNull(requestEligibilityCriteria);
        CoreSettings coreSettings = requestEligibilityCriteria.getRequestSettings();
        assertEquals(1, coreSettings.size());
        CoreSetting coreSetting = coreSettings.get(0);
        assertEquals("Test Primary Care", coreSetting.getTypeOfCare());
        List<ClinicalServices> clinicalServicesList = createUpdatedPrimaryCareClinicalServices();
        requestEligibilityCriteria = requestEligibilityCriteriaService.fetchRequestEligibiltyCriteria("1", clinicalServicesList, createClinicalServicesForCustomRequest(), uriInfo);
        TestCase.assertNotNull(requestEligibilityCriteria);
        coreSettings = requestEligibilityCriteria.getRequestSettings();
        assertEquals(1, coreSettings.size());
        coreSetting = coreSettings.get(0);
        assertEquals("Test Primary Care Updated", coreSetting.getTypeOfCare());

    }

    private List<ClinicalServices> createClinicalServices() {
        List<ClinicalServices> clinicalServicesList = new ArrayList<ClinicalServices>();
        ClinicalServices cs1 = new ClinicalServices();
        cs1.setId("323");
        cs1.setName("Test Primary Care");
        cs1.setSubmittedRequestLimit(2);
        cs1.setCreatedBy("Test User");
        cs1.setCreatedDate(new Date());
        StopCodes stopCodes = new StopCodes();
        StopCode sc1 = new StopCode();
        sc1.setPrimary("350");
        StopCode sc2 = new StopCode();
        sc2.setPrimary("323");
        StopCode sc3 = new StopCode();
        sc3.setPrimary("322");
        stopCodes.add(sc1);
        stopCodes.add(sc2);
        stopCodes.add(sc3);
        cs1.setStopCodes(stopCodes);

        ClinicalServices cs2 = new ClinicalServices();
        cs2.setId("150");
        cs2.setName("Test Radiology");
        cs2.setCreatedBy("Test User");
        cs2.setCreatedDate(new Date());
        cs2.setSubmittedRequestLimit(3);
        StopCodes stopCodes1 = new StopCodes();
        StopCode sc4 = new StopCode();
        sc4.setPrimary("222");
        sc4.setSecondary("333");

        stopCodes1.add(sc4);
        cs2.setStopCodes(stopCodes1);

        clinicalServicesList.add(cs1);
        clinicalServicesList.add(cs2);
        return clinicalServicesList;
    }

    private List<ClinicalServices> createUpdatedClinicalServices() {
        List<ClinicalServices> clinicalServicesList = new ArrayList<ClinicalServices>();
        ClinicalServices cs = new ClinicalServices();
        cs.setId("150");
        cs.setName("Test Radiology");
        cs.setCreatedBy("Test User");
        cs.setCreatedDate(new Date());
        StopCodes stopCodes = new StopCodes();
        StopCode sc = new StopCode();
        sc.setPrimary("222");
        sc.setSecondary("333");

        stopCodes.add(sc);
        cs.setStopCodes(stopCodes);

        clinicalServicesList.add(cs);
        clinicalServicesList.add(cs);
        return clinicalServicesList;
    }

    private List<ClinicalServices> createUpdatedPrimaryCareClinicalServices() {
        List<ClinicalServices> clinicalServicesList = new ArrayList<ClinicalServices>();
        ClinicalServices cs = new ClinicalServices();
        cs.setId("323");
        cs.setName("Test Primary Care Updated");
        cs.setCreatedBy("Test User");
        cs.setCreatedDate(new Date());
        StopCodes stopCodes = new StopCodes();
        StopCode sc = new StopCode();
        sc.setPrimary("350");
        StopCode sc2 = new StopCode();
        sc2.setPrimary("323");
        StopCode sc3 = new StopCode();
        sc3.setPrimary("322");
        stopCodes.add(sc);
        stopCodes.add(sc2);
        stopCodes.add(sc3);
        cs.setStopCodes(stopCodes);
        clinicalServicesList.add(cs);
        return clinicalServicesList;
    }

    private List<ClinicalServices> createClinicalServicesForCustomRequest() {
        List<ClinicalServices> clinicalServicesList = new ArrayList<ClinicalServices>();
        ClinicalServices cs = new ClinicalServices();
        cs.setId("CR1");
        cs.setName("Express Care");
        cs.setCreatedBy("Test User");
        cs.setCreatedDate(new Date());
        cs.setSubmittedRequestLimit(1);
        StopCodes stopCodes = new StopCodes();
        cs.setStopCodes(stopCodes);
        clinicalServicesList.add(cs);
        return clinicalServicesList;
    }
}
